#version 330
#extension GL_EXT_gpu_shader4 : enable
//Pseudo kleinian fluidMod01.fsh by  guil
//https://www.shadertoy.com/view/Xt23RR
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// Created by S.Guillitte
//Fluid technique based on Fluid with Obstacles by Effie and 2D fluids by andregc (https://www.shadertoy.com/view/4llGWl)


#define PI 3.14159265358979


float hash( in vec3 p ) 
{
    return fract(sin(p.x*15.32758341+p.y*39.786792357+p.z*59.4583127+7.5312) * 43758.236237153)-.5;
}

vec3 hash3( in vec3 p )
{
    return vec3(hash(p),hash(p+1.5),hash(p+2.5));
}

//mat2 m2= mat2(.8,.6,-.6,.8);

// Gabor/Voronoi mix 3x3 kernel (some artifacts for v=1.)
float gavoronoi3(in vec3 p)
{    
    vec3 ip = floor(p);
    vec3 fp = fract(p);
    float f = 12.*PI;//frequency
    float v = .8;//cell variability <1.
    float dv = .9;//direction variability <1.
    vec3 dir = vec3(.1);
    float va = 0.0;
   	float wt = 0.0;
    for (int i=-1; i<=1; i++) 
	for (int j=-1; j<=1; j++) 
    for (int k=-1; k<=1; k++)    
	{		
        vec3 o = vec3(i, j, k)-.5;
        vec3 h = hash3((ip - o));
        vec3 pp = fp +o  -h;
        float d = dot(pp, pp);
        float w = exp(-d*4.);
        wt +=w;
        h = dv*h+dir;//h=normalize(h+dir);
        va += cos(dot(pp,h)*f/v)*w;
	}    
    return va/wt;
}


vec3 field (in vec3 p){
    p=p/4.;
	for (int i=0; i<=5; i++)p=abs(p)/dot(p,p)-1.;  
    return p;
}

float noise( vec3 p)
{   
    return gavoronoi3(p);
}



vec3 euler(vec3 uv, float t) {
	t /= 6.;
	for(int i = 0; i < 6; ++i) {
		uv -= field(uv)*t;
	}
	return uv;
}

vec3 rk4(vec3 uv, float t) {
    t /= 3.;
    for(int i = 0; i < 3; ++i) {
        
        	vec3 k1 = -field(uv);
        	vec3 k2 = -field(uv + k1*t/2.);
        	vec3 k3 = -field(uv + k2*t/2.);
	        vec3 k4 = -field(uv + k3*t);
    	    uv = uv + t/6.*(k1+2.*k2+2.*k2+k3);
        
    }
	
    return uv;
}

float fluid(vec3 uv, float t) {
	float t1 = t*0.5;
	float t2 = t1 + 0.5;
	vec3 uv1 = rk4(uv, t1);
	vec3 uv2 = rk4(uv, t2);
	float c1 = noise(uv1);
	float c2 = noise(uv2);
	return 4.*mix(c2,c1,t);
    
}


float map(vec3 p){
	float t = fract(iTime);
    return fluid(p,t);
    
}


mat2 rot(float a) {
	return mat2(cos(a),sin(a),-sin(a),cos(a));	
}

vec2 iSphere( in vec3 ro, in vec3 rd, in vec4 sph )//from iq
{
	vec3 oc = ro - sph.xyz;
	float b = dot( oc, rd );
	float c = dot( oc, oc ) - sph.w*sph.w;
	float h = b*b - c;
	if( h<0.0 ) return vec2(-1.0);
	h = sqrt(h);
	return vec2(-b-h, -b+h );
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
	float time = iTime;
    vec2 q = gl_FragCoord.xy / iResolution.xy;
    vec2 p = -1.0 + 2.0 * q;
    p.x *= iResolution.x/iResolution.y;
    vec2 m = vec2(0.);
	if( iMouse.z>0.0 )m = iMouse.xy/iResolution.xy*3.14;
    m-=.5;

    // camera

    vec3 ro = vec3(4.);
    ro.yz*=rot(m.y);
    ro.xz*=rot(m.x+ 0.1*time);
    vec3 ta = vec3( 0.0 , 0.0, 0.0 );
    vec3 ww = normalize( ta - ro );
    vec3 uu = normalize( cross(ww,vec3(0.0,1.0,0.0) ) );
    vec3 vv = normalize( cross(uu,ww));
    vec3 rd = normalize( p.x*uu + p.y*vv + 4.0*ww );

    
    vec2 tmm = iSphere( ro, rd, vec4(0.,0.,0.,2.) );

	float c;
    
   	if (tmm.x<0.)c = -1.;
    else c=abs( map(ro+rd*tmm.x)*1.);
    vec3 col = .3 + .7*sin(vec3(1.,2.,3.)+c);
    if(c<0.)col=vec3(.4);
	
	// shade
    
    
    col = clamp(col,0.,1.);
    gl_FragColor = vec4( col, 1.0 );
}
	

